/* Copyright (c) 2005 Andrew Choi.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.

3. All advertising materials mentioning features or use of this
   software must display the following acknowledgement:

     This product includes software developed by Andrew Choi.

4. The name "Andrew Choi" may not be used to endorse or promote
   products derived from this software without specific prior written
   permission.

THIS SOFTWARE IS PROVIDED BY ANDREW CHOI "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.  IN NO EVENT SHALL ANDREW CHOI BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.  */

#include <Foundation/Foundation.h>

#include "MIDI.h"

MIDIClientRef myMIDIClient = NULL;

extern void UpdateDeviceTables();  /* In Device.m.  */

static void MIDISetupChange()
{
  UpdateDeviceTables();
}

static void myMIDINotifyProc(const MIDINotification *message, void *refCon)
{
  if (message->messageID == kMIDIMsgSetupChanged)
    MIDISetupChange();
}

void Initialize()
{
  if (myMIDIClient)
    @throw EXCEPTION(@"TOE is already initialized");
  
  if (MIDIClientCreate(CFSTR("TOE"), myMIDINotifyProc, NULL, &myMIDIClient) != noErr)
    @throw EXCEPTION(@"Cannot initialize TOE as MIDI client");
}

void Terminate()
{
  if (!myMIDIClient)
    @throw EXCEPTION(@"TOE is already terminated");
  
  (void) MIDIClientDispose(myMIDIClient);
  
  myMIDIClient = NULL;
}

void CheckMIDISetupChange()
{
  /* The callback registered at MIDI client creation to notify us when changes are made in AMS is only called when the run loop is run!  So we'll poll for any change here.  */
  (void) CFRunLoopRunInMode(kCFRunLoopDefaultMode, 0, 1);
}
